% generate the DATA FOR AR(2) CASE in our paper
% d- sample rate (d out of 10)
% n-subjects
% phi1,phi2-coefficients for ar(2) model
% L-the total numbers of observations for each subject, 
%i.e. the time units is 1/L in our paper
function [y,x]=rawdata_quality_ar2(n,d,phi1,phi2,L)
J=L/10;%generate J observation for each subject
x=zeros(d*J,n,100);
y=zeros(d*J,n,100);
for j=1:100
for i=1:n
%genenrate an AR(2) realization and randomly select d time points from 10 time points
    ar2(1)=normrnd(0,1);
    ar2(2)=phi1*ar2(1)+normrnd(0,sqrt(5/12));
    for k=3:L
    ar2(k)=phi1*ar2(k-1)+phi2*ar2(k-2)+normrnd(0,sqrt(5/12));
    end
for kk=1:J
    A=randperm(10);
    B(((kk-1)*d+1):((kk-1)*d+d))=(kk-1)*10+sort(A(1:d));
end
x(1:d*J,i,j)=B./L';
y(1:d*J,i,j)=1+0.3.*(B'./L).^0.5+(1+0.3.*(B'./L).^0.5).*ar2(B)';
end
end
x1=x;
y1=y;
save(['C:\2012-06-20\2012-06-20-1\2012-06-20-1\\U of M\quality\rawdataic_for_univariate_spc_',num2str(L),'_08n',num2str(n),'_J',num2str(d*J),'ar2boots.mat'],'y1','x1')